/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.util;

import java.io.File;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.Collection;
import java.util.regex.Pattern;
import oracle.ide.model.Project;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaFile;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.model.JavaProject;

public class Helpers {
    public static void removeClasses(Project prj, URL sourceFile) {
        String[] list = Helpers.getClasses(prj, sourceFile);
        Helpers.removeClasses(prj, list);
    }

    public static void removeClasses(Project prj, String[] fqClassNames) {
        URL outputDirectory = JavaProject.getInstance(prj).getOutputDirectory();
        File outFile = new File(outputDirectory.getPath());
        for (int i = 0; i < fqClassNames.length; ++i) {
            File file = new File(outFile, fqClassNames[i].replace('.', File.separatorChar));
            String cname = file.getName();
            new File(file.getPath() + ".class").delete();
            file = file.getParentFile();
            if (file == null) continue;
            Pattern pattern = Pattern.compile("^.*" + cname + "\\$..*\\.class$");
            String[] files = file.list();
            for (int j = 0; files != null && j < files.length; ++j) {
                if (!pattern.matcher(files[j]).matches()) continue;
                new File(file, files[j]).delete();
            }
        }
    }

    public static String[] getClasses(Project prj, URL sourceURL) {
        JavaManager javaManager = JavaManager.getJavaManager(prj);
        JavaFile srcFile = javaManager.getFile(sourceURL);
        return srcFile != null ? Helpers.getClasses(srcFile) : new String[]{};
    }

    public static String[] getClasses(JavaFile sourceOrJavaFile) {
        Collection classes = sourceOrJavaFile.getClasses();
        JavaClass[] aclasses = classes.toArray(new JavaClass[classes.size()]);
        String[] result = new String[aclasses.length];
        for (int i = 0; i < aclasses.length; ++i) {
            result[i] = aclasses[i].getQualifiedName();
        }
        return result;
    }

    public static boolean isClassAccessible(JavaClass cls, String pkg) {
        boolean isAccessible;
        int mods = cls.getModifiers();
        boolean bl = isAccessible = cls.getOwningClass() == null || Modifier.isStatic(mods);
        if (isAccessible && !(isAccessible = Modifier.isPublic(mods)) && !Modifier.isPrivate(mods)) {
            String clsPkg = cls.getPackageName();
            isAccessible = ModelUtil.areEqual((Object)pkg, (Object)clsPkg);
        }
        return isAccessible;
    }
}

