/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.wizard.project;

import java.net.URL;
import oracle.ide.model.Project;
import oracle.ide.model.TechnologyScope;
import oracle.ide.model.TechnologyScopeConfiguration;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.util.Namespace;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.cmd.NewEmptyProjectCommand;
import oracle.jdeveloper.model.J2eeSettings;
import oracle.jdeveloper.model.JProjectLibraries;
import oracle.jdeveloper.model.JProjectUtil;
import oracle.jdeveloper.model.JavaProject;
import oracle.jdeveloper.model.PathsConfiguration;
import oracle.jdeveloper.wizard.apptemplate.WizardDefaultsProviderManager;
import oracle.jdevimpl.wizard.project.ProjectWizardKeys;

public class WizardApplyHandler
implements ProjectWizardKeys {
    public static void applyWizardChanges(Project project, Namespace wizardData, Workspace workspace) {
        JProjectLibraries newLibs;
        String defPkg = !wizardData.contains("DefaultPackage") ? JavaProject.generateDefaultPackageName(project) : (String)wizardData.get("DefaultPackage");
        NewEmptyProjectCommand.setProjectPackage(defPkg, project, workspace);
        URLPath srcPath = (URLPath)wizardData.get("ProjectSourcePath");
        if (srcPath != null) {
            PathsConfiguration.getInstance((Project)project).setProjectSourcePath(srcPath);
        } else {
            TechnologyScopeConfiguration techScopeConf;
            TechnologyScope techScope;
            WizardDefaultsProviderManager wdpm = WizardDefaultsProviderManager.getManager();
            if (wdpm.containsDefaultForTechnologyScope(techScope = (techScopeConf = TechnologyScopeConfiguration.getInstance((PropertyStorage)project)).getTechnologyScope(), "ProjectSourcePath")) {
                String relPath = wdpm.getDefaultForTechScope(techScope, "ProjectSourcePath");
                URL srcURL = URLFactory.newDirURL((URL)URLFileSystem.getParent((URL)project.getURL()), (String)relPath);
                PathsConfiguration.getInstance((Project)project).setProjectSourcePath(new URLPath(srcURL));
            }
        }
        URL url = (URL)wizardData.get("HtmlRootDir");
        if (url != null) {
            J2eeSettings.getInstance((Project)project).setHtmlRootDirectory(url);
        }
        if ((url = (URL)wizardData.get("OutputDirectory")) != null) {
            url = URLFileSystem.canonicalize((URL)url);
            JProjectUtil.setOutputDirectory(project, url);
        } else {
            TechnologyScopeConfiguration techScopeConf;
            TechnologyScope techScope;
            WizardDefaultsProviderManager wdpm = WizardDefaultsProviderManager.getManager();
            if (wdpm.containsDefaultForTechnologyScope(techScope = (techScopeConf = TechnologyScopeConfiguration.getInstance((PropertyStorage)project)).getTechnologyScope(), "OutputDirectory")) {
                String relPath = wdpm.getDefaultForTechScope(techScope, "OutputDirectory");
                URL outputURL = URLFactory.newDirURL((URL)URLFileSystem.getParent((URL)project.getURL()), (String)relPath);
                JProjectUtil.setOutputDirectory(project, outputURL);
            }
        }
        JProjectLibraries libs = (JProjectLibraries)wizardData.get("oracle.jdevimpl.config.JProjectLibraries");
        if (libs != null && (newLibs = JProjectLibraries.getInstance((PropertyStorage)project)) != null) {
            libs.copyTo((Object)newLibs);
        }
    }
}

