<?xml version="1.0" ?>
<!--
NAME
    cmkutblspc.xsl
DESCRIPTION
    Convert mdapi TABLESPACE_T document to TABLESPACE document (editable XML)

MODIFIED    MM/DD/YY
    pkaliren    05/15/08 - Merge 11GC functionality
    xshen       02/17/05 - fixing ordering 
    ngade       11/09/04 - fix increment size 
    ngade       08/09/04 - ngade_cm_0802
    ngade       08/09/04 - fix sort field
    ngade       08/02/04 - Initial version
 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<!-- Top level imports -->
<xsl:import href="cmkucommon.xsl"/>
<xsl:import href="cmkustorage.xsl"/>

<xsl:param name="COLUMN_SORTBY">NAME</xsl:param>

<!-- Top level template for all objects -->
<xsl:template match="/">
  <xsl:apply-templates/>
</xsl:template>

<xsl:template match="RESULTSET | ROWSET">
  <xsl:for-each select="ROW">
    <xsl:apply-templates/>
  </xsl:for-each>
</xsl:template>

<!-- Temlate for Extent Management-->
<xsl:template name ="ExtentManagement">
  <xsl:param name="BlkSize"/>
  <xsl:param name="Undo">0</xsl:param>
  <xsl:choose>
    <xsl:when test="BITMAPPED = 0">
      <EXTENT_MANAGEMENT>        
        <xsl:text>DICTIONARY</xsl:text>        
      </EXTENT_MANAGEMENT>          
      <xsl:call-template name="DoStorage">
        <xsl:with-param name="ParentNode" select="."/>
        <xsl:with-param name="BlkSize" select="BLOCKSIZE"/>
      </xsl:call-template>      
    </xsl:when>
    <xsl:otherwise>
      <EXTENT_MANAGEMENT>
        <xsl:text>LOCAL</xsl:text>
      </EXTENT_MANAGEMENT>   
      <xsl:call-template name="DoStorage">
        <xsl:with-param name="ParentNode" select="."/>
        <xsl:with-param name="BlkSize" select="BLOCKSIZE"/>
      </xsl:call-template>
       
      <xsl:choose>
        <xsl:when test="(FLAGS mod 2) = 1">
          <ALLOCATION_TYPE>
            <xsl:text>AUTOMATIC</xsl:text>
          </ALLOCATION_TYPE>
        </xsl:when>
        <xsl:when test="(FLAGS mod 4) = 0">
          <ALLOCATION_TYPE>
            <xsl:text>USER</xsl:text>
          </ALLOCATION_TYPE>
        </xsl:when>

        <xsl:when test="(FLAGS mod 4) = 2">
          <ALLOCATION_TYPE>
            <xsl:text>UNIFORM</xsl:text>
          </ALLOCATION_TYPE>
          <SIZE>
            <xsl:value-of select="DFLINIT * $BlkSize"/>
          </SIZE>                  

        </xsl:when>
      </xsl:choose>
      <xsl:if test="$Undo=0">
        <xsl:call-template name="SegmentSpaceManagement"/>
      </xsl:if>
    </xsl:otherwise>  
  </xsl:choose>  
</xsl:template>

<!-- Template for Segment Space Management -->
<xsl:template name="SegmentSpaceManagement">
  <SEGMENT_SPACE_MANAGEMENT>
    <xsl:choose>
      <xsl:when test="((FLAGS mod 64) >= 32)">
        <xsl:text>AUTO</xsl:text>
      </xsl:when>
      <xsl:otherwise>
        <xsl:text>MANUAL</xsl:text>
      </xsl:otherwise>
    </xsl:choose>
  </SEGMENT_SPACE_MANAGEMENT>        
</xsl:template>

<!-- Template for Undo Tablespace -->
<xsl:template name="DoUndoTS">
  <xsl:variable name="BlkSize" select="BLOCKSIZE"/>
  <xsl:if test="FILESPEC/FILESPEC_ITEM">
    <DATAFILE_LIST>
      <xsl:for-each select="FILESPEC/FILESPEC_ITEM">
       <xsl:sort select="*[local-name()=$COLUMN_SORTBY]"/>
        <DATAFILE_LIST_ITEM NAME="{FNAME}">
          <xsl:call-template name="DoDataFile">
            <xsl:with-param name="BlkSize" select="$BlkSize"/>
          </xsl:call-template>
        </DATAFILE_LIST_ITEM>
      </xsl:for-each>
    </DATAFILE_LIST>
  </xsl:if>      
  <xsl:call-template name="ExtentManagement">
    <xsl:with-param name="BlkSize" select="$BlkSize"/>
    <xsl:with-param name="Undo">1</xsl:with-param>
  </xsl:call-template>
</xsl:template>

<!-- Template for Temporary Tablespace -->
<xsl:template name ="DoTemporaryTS">
  <xsl:variable name="BlkSize" select="BLOCKSIZE"/>
    <xsl:if test="FILESPEC/FILESPEC_ITEM">
      <DATAFILE_LIST>
        <xsl:for-each select="FILESPEC/FILESPEC_ITEM">
          <xsl:sort select="*[local-name()=$COLUMN_SORTBY]"/>
          <DATAFILE_LIST_ITEM NAME="{FNAME}">
            <xsl:call-template name="DoDataFile">
              <xsl:with-param name="BlkSize" select="$BlkSize"/>
            </xsl:call-template>
          </DATAFILE_LIST_ITEM>
        </xsl:for-each>
      </DATAFILE_LIST>
    </xsl:if>
    <ALLOCATION_TYPE>
      <xsl:text>UNIFORM</xsl:text>
    </ALLOCATION_TYPE>
    <EXTENT_MANAGEMENT>
      <xsl:text>LOCAL</xsl:text>
    </EXTENT_MANAGEMENT>
    <SIZE>
      <xsl:value-of select="DFLINIT * $BlkSize"/>
    </SIZE>
</xsl:template>

<!-- Template for Permanent Tablespace -->
<xsl:template name ="DoPermanentTS">
  <xsl:variable name="BlkSize" select="BLOCKSIZE"/>
    <DATAFILE_LIST>
      <xsl:for-each select="FILESPEC/FILESPEC_ITEM">
       <xsl:sort select="*[local-name()=$COLUMN_SORTBY]"/>
        <DATAFILE_LIST_ITEM NAME="{FNAME}">
          <xsl:call-template name="DoDataFile">
            <xsl:with-param name="BlkSize" select="$BlkSize"/>
          </xsl:call-template>
        </DATAFILE_LIST_ITEM>
      </xsl:for-each>
    </DATAFILE_LIST>
  <xsl:call-template name="ExtentManagement">
    <xsl:with-param name="BlkSize" select="$BlkSize"/>
  </xsl:call-template>
</xsl:template>  
  
<!-- Template to output filespec and autoextend clause for tablespaces -->
<xsl:template name="DoDataFile">
  <xsl:param name="BlkSize"/>
  <NAME>
    <xsl:value-of select="FNAME"/>
  </NAME>
  <SIZE>
    <xsl:value-of select="FSIZE * $BlkSize"/>
  </SIZE>
  <xsl:choose>
    <xsl:when test="MAXEXTEND > 0">
      <AUTOEXTEND>
        <xsl:text>Y</xsl:text>
      </AUTOEXTEND>
      <INCREMENT>
        <xsl:value-of select="INC * $BlkSize"/>
      </INCREMENT>
      <xsl:choose>
        <xsl:when test="(MAXEXTEND * $BlkSize) > 2147483647">
          <MAX_FILE_SIZE>      
            <xsl:value-of select = "floor((MAXEXTEND * $BlkSize) div 1048576)"/>
            <xsl:text>M</xsl:text>
          </MAX_FILE_SIZE>
        </xsl:when>
        <xsl:otherwise>
          <MAX_FILE_SIZE>
            <xsl:value-of select = "MAXEXTEND * $BlkSize"/>
          </MAX_FILE_SIZE>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:when>
    <xsl:otherwise>
      <AUTOEXTEND>
        <xsl:text>N</xsl:text>
      </AUTOEXTEND>
    </xsl:otherwise>
  </xsl:choose>
  
  
</xsl:template>

<!-- Main Template -->
<xsl:template match="TABLESPACE_T">
  <TABLESPACE>
    <!-- name -->
    <NAME>
      <xsl:value-of select="NAME"/>
    </NAME> 
    <!-- blocksize -->
    <BLOCKSIZE>
      <xsl:value-of select="BLOCKSIZE"/>
    </BLOCKSIZE>
    <!-- logging -->
    <xsl:choose>
      <xsl:when test="(DFLOGGING mod 2) = 0">
        <LOGGING>
          <xsl:text>NOLOGGING</xsl:text>
        </LOGGING>
      </xsl:when>
      <xsl:otherwise>
        <LOGGING>    
          <xsl:text>LOGGING</xsl:text>
        </LOGGING>        
      </xsl:otherwise>
    </xsl:choose>
    <!-- Status -->
    <xsl:choose>
      <xsl:when test="STATUS = 1">
        <STATUS>      
          <xsl:text>ONLINE</xsl:text>
        </STATUS>
      </xsl:when>
      <xsl:when test="STATUS = 2">
        <STATUS>
          <xsl:text>OFFLINE</xsl:text>
        </STATUS>        
      </xsl:when>
      <xsl:when test="STATUS = 3">
        <STATUS>
          <xsl:text>INVALID</xsl:text>
        </STATUS>
      </xsl:when>
      <xsl:when test="STATUS = 4">
        <STATUS>
          <xsl:text>READ ONLY</xsl:text>
        </STATUS>         
      </xsl:when>
    </xsl:choose>    
    <!-- Type -->
    <xsl:choose>
      <xsl:when test="CONTENTS = 0">
        <xsl:choose>
          <xsl:when test="(FLAGS mod 32) >= 16">
            <TYPE>      
              <xsl:text>UNDO</xsl:text>
            </TYPE> 
            <xsl:call-template name="DoUndoTS"/>            
          </xsl:when>
          <xsl:otherwise>
            <TYPE>          
              <xsl:text>PERMANENT</xsl:text>
            </TYPE> 
            <xsl:call-template name="DoPermanentTS"/>                         
          </xsl:otherwise>
        </xsl:choose>
      </xsl:when>
      <xsl:otherwise>
        <TYPE>
          <xsl:text>TEMPORARY</xsl:text>
        </TYPE>
        <xsl:call-template name="DoTemporaryTS"/>
      </xsl:otherwise>        
    </xsl:choose>
  </TABLESPACE>
</xsl:template>
</xsl:stylesheet>
