<?xml version="1.0"?>
<!-- 
NAME
    kugrant.xsl
DESCRIPTION
    XSLT stylesheet for XML => DDL conversion of md$_objgrant_t ADTs
NOTES
    Do NOT modify this file under any circumstance. Copy the file
    if you wish to use this stylesheet with an external XML/XSL parser

MODIFIED	MM/DD/YY
    dgagne      06/16/08 - add comments around grant name
    lbarton     01/13/06 - bug 4951322: WITH HIERARCHY OPTION 
    lbarton	11/02/05 - Bug 4715313: reformat files for use with XMLSpy 
    htseng	07/24/03 - add long_name 
    htseng	08/02/02 - add grantee parse param
    htseng	07/26/02 - add more parse params
    htseng	11/08/01 - bug 2100506 - follow the object_type roule.
    lbarton	06/01/01 - remove oradb-style imports
    lbarton	10/18/00 - support DDL parsing
    gclaborn    10/30/00 - Add external imports; change name
    lbarton	07/24/00 - use uriref in import
    lbarton	03/17/00 - Add module header
 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
 <!-- Import required scripts -->
 <xsl:import href="kucommon.xsl"/>
 <!-- Top-level parameters -->
 <xsl:param name="PRETTY">1</xsl:param>
 <xsl:param name="SQLTERMINATOR">1</xsl:param>
 <!-- params for parse -->
 <xsl:param name="PRS_DDL">0</xsl:param>
 <xsl:param name="PRS_DELIM">\{]`</xsl:param>
 <xsl:param name="PRS_VERB">0</xsl:param>
 <xsl:param name="PRS_OBJECT_TYPE">0</xsl:param>
 <xsl:param name="PRS_SCHEMA">0</xsl:param>
 <xsl:param name="PRS_NAME">0</xsl:param>
 <xsl:param name="PRS_GRANTEE">0</xsl:param>
 <xsl:param name="PRS_GRANTOR">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_TYPE">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_SCHEMA">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_NAME">0</xsl:param>
 <xsl:template match="OBJGRANT_T">
  <!-- *******************************************************************
Template: OBJGRANT_T - template for object grants
******************************************************************** -->
  <xsl:call-template name="DoParse">
   <xsl:with-param name="Verb">GRANT</xsl:with-param>
   <xsl:with-param name="ObjectType">OBJECT_GRANT</xsl:with-param>
   <xsl:with-param name="Grantor" select="GRANTOR"/>
   <xsl:with-param name="Grantee" select="GRANTEE"/>
   <xsl:with-param name="BaseSchemaNode" select="BASE_OBJ/OWNER_NAME"/>
   <xsl:with-param name="BaseNameNode" select="BASE_OBJ/NAME"/>
   <xsl:with-param name="BaseObjectType" select="BASE_OBJ/TYPE"/>
  </xsl:call-template>
  <xsl:text>GRANT </xsl:text>
  <!-- The privname is either in a list, or there is only one, but both cannot
       exist in the same .xml document.   Because of this, instead of adding
       code to see which version is present, just try to print both. -->
  <xsl:for-each select="PRIVS/PRIVS_ITEM">
   <!-- if not the first item, add a comma and space before the next item -->
   <xsl:if test="position() != 1">
    <xsl:text>, </xsl:text>
   </xsl:if>
   <xsl:value-of select="PRIVNAME"/>
  </xsl:for-each>
  <xsl:value-of select="PRIVNAME"/>
  <xsl:if test="COLNAME">
   <xsl:text> ("</xsl:text>
   <xsl:value-of select="COLNAME"/>
   <xsl:text>")</xsl:text>
  </xsl:if>
  <xsl:text> ON </xsl:text>
  <xsl:choose>
   <xsl:when test="BASE_OBJ/TYPE_NUM=23">
    <xsl:text>DIRECTORY "</xsl:text>
    <xsl:value-of select="BASE_OBJ/NAME"/>
    <xsl:text>" </xsl:text>
   </xsl:when>
   <xsl:otherwise>
    <xsl:if test="BASE_OBJ/TYPE_NUM=28">
     <xsl:text>JAVA SOURCE </xsl:text>
    </xsl:if>
    <xsl:if test="BASE_OBJ/TYPE_NUM=30">
     <xsl:text>JAVA RESOURCE </xsl:text>
    </xsl:if>
    <xsl:choose>
     <xsl:when test="LONG_NAME">
      <xsl:text>"</xsl:text>
      <xsl:value-of select="BASE_OBJ/OWNER_NAME"/>
      <xsl:text>"."</xsl:text>
      <xsl:value-of select="LONG_NAME"/>
      <xsl:text>" </xsl:text>
     </xsl:when>
     <xsl:otherwise>
      <xsl:apply-templates select="BASE_OBJ"/>
     </xsl:otherwise>
    </xsl:choose>
   </xsl:otherwise>
  </xsl:choose>
  <xsl:text>TO </xsl:text>
  <xsl:apply-templates select="GRANTEE">
   <xsl:with-param name="gtype">OBJGRANT</xsl:with-param>
   <xsl:with-param name="wgo" select="WGO"/>
  </xsl:apply-templates>
 </xsl:template>
 <xsl:template match="SYSGRANT_T">
  <!-- *******************************************************************
Template: SYSGRANT_T - template for system privilege grants
******************************************************************** -->
  <xsl:call-template name="DoParse">
   <xsl:with-param name="Verb">GRANT</xsl:with-param>
   <xsl:with-param name="ObjectType">OBJECT_GRANT</xsl:with-param>
  </xsl:call-template>
  <xsl:text>GRANT </xsl:text>
  <xsl:value-of select="PRIVNAME"/>
  <xsl:text> TO </xsl:text>
  <xsl:apply-templates select="GRANTEE">
   <xsl:with-param name="gtype">SYSGRANT</xsl:with-param>
   <xsl:with-param name="wgo" select="WGO"/>
  </xsl:apply-templates>
 </xsl:template>
 <xsl:template match="GRANTEE">
  <!-- *******************************************************************
Template: GRANTEE
Parameters:
  gtype = type of grant, either 'OBJGRANT' or 'SYSGRANT'
  wgo = WGO element
******************************************************************** -->
  <xsl:param name="gtype" select="''"/>
  <xsl:param name="wgo" select="''"/>
  <xsl:if test=".!='PUBLIC'">
   <xsl:text>"</xsl:text>
  </xsl:if>
  <xsl:value-of select="."/>
  <xsl:if test=".!='PUBLIC'">
   <xsl:text>"</xsl:text>
  </xsl:if>
  <xsl:if test="$wgo!=0">
   <xsl:choose>
    <xsl:when test="$gtype='SYSGRANT'">
     <xsl:text> WITH ADMIN OPTION</xsl:text>
    </xsl:when>
    <xsl:when test="$gtype='OBJGRANT'">
     <xsl:if test="($wgo mod 4)>=2"> WITH HIERARCHY OPTION</xsl:if>
     <xsl:if test="($wgo mod 2)=1"> WITH GRANT OPTION</xsl:if>
    </xsl:when>
   </xsl:choose>
  </xsl:if>
  <xsl:if test="$SQLTERMINATOR=1">
   <xsl:text>;</xsl:text>
   <!-- Terminate the SQL statement -->
  </xsl:if>
 </xsl:template>
</xsl:stylesheet>
