<?xml version="1.0"?>
<!--
 Copyright (c) 2005, 2012, Oracle and/or its affiliates. All rights reserved. 
NAME
    kusview.xsl
DESCRIPTION
    Convert mdapi VIEW_T document to VIEW document (SXML)

MODIFIED        MM/DD/YY
    abodge      06/29/12 - Fix xmlns attribute problem
    abodge      09/21/11 - Sort view columns when in CM_MODE
    abodge      06/28/11 - Add param defns
    lbarton     07/24/09 - bug 8342311: view subquery restriction clause
    rapayne     01/24/07 - Add support for READ_ONLY
    lbarton     11/28/06 - missing import
    akruglik    09/07/06 - Column Map Views got rechristened as Editioning
                           Views
    lbarton     06/26/06 - PARSE_EXPRESSIONS param 
    rapayne     06/07/06 - Proj 20521: add editioning view support.
    lbarton     03/27/06 - bug 5118027: CONSTRAINTS and REF_CONSTRAINTS params 
                           for SXML 
    htseng      01/12/05 - give default schema for under_clause 
    lbarton     11/09/05 - bug 4724986: fix handling of xmlns 
    sdavidso    11/02/05 - fix inconsistent stylesheet format 
    htseng      09/08/05 - separate schemaname and name in under_clause 
    htseng      02/07/05 - Initial version
 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns="http://xmlns.oracle.com/ku">
 <!-- Top level imports -->
 <xsl:import href="kuscomm.xsl"/>
 <xsl:import href="kuscnstr.xsl"/>
 <xsl:import href="kustbphy.xsl"/>
 <!-- Top-level parameters -->
 <xsl:param name="CONSTRAINTS">1</xsl:param>
 <xsl:param name="REF_CONSTRAINTS">1</xsl:param>
 <xsl:param name="PARSE_EXPRESSIONS">0</xsl:param>
 <xsl:param name="PHYSICAL_PROPERTIES">1</xsl:param>
 <xsl:param name="SEGMENT_ATTRIBUTES">1</xsl:param>
 <!-- Templates -->
 <xsl:template match="VIEW_T">
  <!-- *******************************************************************
Template: VIEW_T - top-level template for VIEW.
  This template puts out
   - the opening VIEW element (with xmlns and version attributes)
   - NAME elements
******************************************************************** -->
  <xsl:element name="VIEW" namespace="http://xmlns.oracle.com/ku">
   <xsl:attribute name="version">1.0</xsl:attribute>
   <!-- Editioning Views -->
   <xsl:apply-templates select="SCHEMA_OBJ"/>
   <xsl:if test="(PROPERTY mod 64)>=32">
    <xsl:element name="EDITIONING_VIEW"/>
   </xsl:if>
   <xsl:choose>
    <!-- XMLType_view_clause -->
    <xsl:when test="(PROPERTY mod 2)>=1 and NAME='XMLTYPE' and OWNER_NAME='SYS' 
       and COL_LIST2/COL_LIST2_ITEM[NAME='SYS_NC_ROWINFO$']/OPQMD/SCHEMA_ELMT">
     <xsl:element name="OF_XMLTYPE">
      <xsl:call-template name="XMLSchemaSpec">
       <xsl:with-param name="ColNode" select="COL_LIST2/COL_LIST2_ITEM[NAME='SYS_NC_ROWINFO$']"/>
      </xsl:call-template>
      <!-- with_obj_identifier_clause -->
      <xsl:if test="OIDTEXTLENGTH > 0">
       <xsl:apply-templates select="OIDTEXT"/>
      </xsl:if>
     </xsl:element>
    </xsl:when>
    <!--  object_view_clause -->
    <xsl:when test="(PROPERTY mod 2)>=1">
     <!-- object_view_clause -->
     <xsl:element name="OF_TYPE">
      <xsl:element name="SCHEMA">
       <xsl:value-of select="OWNER_NAME"/>
      </xsl:element>
      <xsl:element name="NAME">
       <xsl:value-of select="NAME"/>
      </xsl:element>
      <!-- with_obj_identifier_clause -->
      <xsl:if test="OIDTEXTLENGTH > 0">
       <xsl:apply-templates select="OIDTEXT"/>
      </xsl:if>
      <!-- under_clause -->
      <xsl:if test="UNDERTEXTLENGTH > 0">
       <xsl:element name="UNDER">
        <xsl:choose>
         <xsl:when test="contains(UNDERTEXT,'.')">
          <xsl:element name="SCHEMA">
           <xsl:value-of select="substring-before(substring
		(normalize-space(UNDERTEXT),string-length('UNDER 1')),'.')"/>
          </xsl:element>
          <xsl:element name="NAME">
           <xsl:value-of select="substring-after(substring
		(normalize-space(UNDERTEXT),string-length('UNDER 1')),'.')"/>
          </xsl:element>
         </xsl:when>
         <xsl:otherwise>
          <xsl:element name="SCHEMA">
           <xsl:value-of select="SCHEMA_OBJ/OWNER_NAME"/>
          </xsl:element>
          <xsl:element name="NAME">
           <xsl:value-of select="substring(normalize-space(UNDERTEXT),
		string-length('UNDER 1'))"/>
          </xsl:element>
         </xsl:otherwise>
        </xsl:choose>
       </xsl:element>
      </xsl:if>
     </xsl:element>
    </xsl:when>
    <xsl:otherwise>
     <!-- relational_view_clause -->
     <xsl:choose>
      <xsl:when test="$CM_MODE=1">
       <!-- Sort columns and add CM-specific information -->
       <xsl:element name="COL_LIST">
        <xsl:for-each select="COL_LIST/COL_LIST_ITEM">
         <xsl:sort select="NAME" data-type="text" lang="en"/>
         <xsl:element name="COL_LIST_ITEM">
          <!-- Include column name as an attribute for diffing -->
          <xsl:attribute name="NAME"><xsl:value-of select="NAME"/></xsl:attribute>
          <!-- Include column number as a no-diff element to allow 
           re-ordering of columns before generating create DDL  -->
          <xsl:element name="COL_NUM">
           <xsl:attribute name="no_diff">1</xsl:attribute>
           <xsl:value-of select="COL_NUM"/>
          </xsl:element>
          <xsl:element name="NAME">
           <xsl:value-of select="NAME"/>
          </xsl:element>
         </xsl:element>
        </xsl:for-each>
       </xsl:element>
      </xsl:when>
      <xsl:otherwise>
       <xsl:call-template name="SimpleColumnList">
        <xsl:with-param name="ColListNode" select="COL_LIST"/>
       </xsl:call-template>
      </xsl:otherwise>
     </xsl:choose>
     <!-- constraints -->
     <xsl:call-template name="TableConstraints"/>
    </xsl:otherwise>
   </xsl:choose>
   <!-- subquery -->
   <xsl:choose>
    <xsl:when test="$PARSE_EXPRESSIONS=1 and PARSED_TEXT">
     <xsl:element name="PARSED_SUBQUERY">
      <xsl:copy-of select="PARSED_TEXT/*"/>
     </xsl:element>
    </xsl:when>
    <xsl:otherwise>
     <xsl:element name="SUBQUERY">
      <xsl:choose>
       <xsl:when test="TEXTVCNT">
        <xsl:for-each select="TEXTVCNT/TEXTVCNT_ITEM">
         <xsl:value-of select="."/>
        </xsl:for-each>
       </xsl:when>
       <xsl:otherwise>
        <xsl:value-of select="TEXT"/>
       </xsl:otherwise>
      </xsl:choose>
     </xsl:element>
    </xsl:otherwise>
   </xsl:choose>
   <!-- subquery restriction clause -->
   <xsl:if test="WITH_OPTION or (PROPERTY mod 32768)>=16384">
    <xsl:element name="RESTRICTION">
     <xsl:choose>
      <xsl:when test="(PROPERTY mod 32768)>=16384">
       <xsl:element name="READ_ONLY"/>
      </xsl:when>
      <xsl:when test="WITH_OPTION">
       <xsl:element name="CHECK_OPTION">
        <xsl:choose>
         <xsl:when test="(WITH_OPTION/FLAGS mod 16)>=8"/>
         <xsl:when test="string-length(WITH_OPTION/NAME)!=0">
          <xsl:element name="CONSTRAINT">
           <xsl:value-of select="WITH_OPTION/NAME"/>
          </xsl:element>
         </xsl:when>
        </xsl:choose>
       </xsl:element>
      </xsl:when>
     </xsl:choose>
    </xsl:element>
   </xsl:if>
  </xsl:element>
 </xsl:template>
 <xsl:template match="OIDTEXT">
  <!-- *******************************************************************
Template: OIDTEXT
******************************************************************** -->
  <xsl:element name="WITH_OBJECT_IDENTIFIER">
   <xsl:element name="ATTRIBUTE_LIST">
    <xsl:call-template name="AttributeListItem">
     <xsl:with-param name="Text" select="."/>
    </xsl:call-template>
   </xsl:element>
  </xsl:element>
 </xsl:template>
 <xsl:template name="AttributeListItem">
  <xsl:param name="Text" select="''"/>
  <!-- *******************************************************************
Template: AttributeListItem
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="contains($Text,',')">
    <xsl:element name="ATTRIBUTE_LIST_ITEM">
     <xsl:element name="NAME">
      <xsl:value-of select="normalize-space(substring-before($Text,','))"/>
     </xsl:element>
    </xsl:element>
    <xsl:call-template name="AttributeListItem">
     <xsl:with-param name="Text" select="substring-after($Text,',')"/>
    </xsl:call-template>
   </xsl:when>
   <xsl:otherwise>
    <xsl:element name="ATTRIBUTE_LIST_ITEM">
     <xsl:element name="NAME">
      <xsl:value-of select="normalize-space($Text)"/>
     </xsl:element>
    </xsl:element>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>
</xsl:stylesheet>
