package org.jdesktop.animation.timing.interpolation;

import java.lang.reflect.Method;
import java.awt.Dimension;

class KeyValuesDimension extends KeyValues<Dimension>
{
    public KeyValuesDimension(final Dimension... values) {
        super(values);
        for (final Dimension value : values) {
            this.values.add(value);
        }
    }
    
    @Override
    public Class<?> getType() {
        return Dimension.class;
    }
    
    @Override
    public void setValue(final Object object, final Method method, final int i0, final int i1, final float fraction) {
        final Dimension value = (Dimension)this.values.get(i0);
        if (i0 != i1) {
            final Dimension v0 = (Dimension)this.values.get(i0);
            final Dimension v2 = (Dimension)this.values.get(i1);
            final Dimension dimension = value;
            dimension.width += (int)((v2.width - v0.width) * fraction + 0.5);
            final Dimension dimension2 = value;
            dimension2.height += (int)((v2.height - v0.height) * fraction + 0.5);
        }
        try {
            method.invoke(object, value);
        }
        catch (Exception e) {
            System.out.println("Problem invoking method in KVFloat.setValue:" + e);
        }
    }
    
    @Override
    public void setValue(final Object object, final Method method, final int index) {
        try {
            method.invoke(object, this.values.get(index));
        }
        catch (Exception e) {
            System.out.println("Problem invoking method in KVFloat.setValue:" + e);
        }
    }
}