package org.jdesktop.animation.timing.interpolation;

import java.lang.reflect.Method;

class KeyValuesDouble extends KeyValues<Double>
{
    public KeyValuesDouble(final double... values) {
        super(values);
        for (final double value : values) {
            this.values.add(value);
        }
    }
    
    @Override
    public Class<?> getType() {
        return Double.TYPE;
    }
    
    @Override
    public void setValue(final Object object, final Method method, final int i0, final int i1, final float fraction) {
        double value;
        if (i0 == i1) {
            value = (double)this.values.get(i0);
        }
        else {
            final double v0 = (double)this.values.get(i0);
            final double v2 = (double)this.values.get(i1);
            value = v0 + (v2 - v0) * fraction;
        }
        try {
            method.invoke(object, value);
        }
        catch (Exception e) {
            System.out.println("Problem invoking method in KVDouble.setValue:" + e);
        }
    }
    
    @Override
    public void setValue(final Object object, final Method method, final int index) {
        try {
            method.invoke(object, this.values.get(index));
        }
        catch (Exception e) {
            System.out.println("Problem invoking method in KVDouble.setValue:" + e);
        }
    }
}