package org.jdesktop.animation.timing.triggers;

import java.util.EventListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.Component;
import org.jdesktop.animation.timing.TimingController;

public class ComponentFocusTrigger extends Trigger
{

	private class ComponentFocusListener extends TriggerListener implements FocusListener
	{
		ComponentFocusEvent event;
		
		protected ComponentFocusListener(final TimingController timer, final Trigger.TriggerAction action, final ComponentFocusEvent event) {
			super(timer, action);
			this.event = event;
		}
		
		public void focusGained(final FocusEvent e) {
			if (this.event == ComponentFocusEvent.FOCUS_IN) {
				this.pullTrigger();
			}
		}
		
		public void focusLost(final FocusEvent e) {
			if (this.event == ComponentFocusEvent.FOCUS_OUT) {
				this.pullTrigger();
			}
		}
	}

    public ComponentFocusTrigger(final TimingController timer, final Component source, final Trigger.TriggerAction action, final ComponentFocusEvent event) {
        this.setupListener(timer, source, action, (TriggerEvent)event);
    }
    
    public ComponentFocusTrigger(final TimingController startTimer, final Component source, final ComponentFocusEvent event, final TimingController stopTimer) {
        super(startTimer, source, (TriggerEvent)event, stopTimer);
    }
    
    @Override
    protected void setupListener(final TimingController timer, final Object source, final Trigger.TriggerAction action, final TriggerEvent event) {
        try {
            final ComponentFocusTrigger.ComponentFocusListener listener = new ComponentFocusTrigger.ComponentFocusListener(timer, action, (ComponentFocusEvent)event);
            this.setupListener(source, (EventListener)listener, "addFocusListener", FocusListener.class);
        }
        catch (Exception e) {
            System.out.println("Exception creating focus listener for object " + source + ": " + e);
        }
    }
}