package org.jdesktop.animation.timing.triggers;

import org.jdesktop.animation.timing.TimingController;

public abstract class TriggerListener
{
    TimingController timer;
    Trigger.TriggerAction action;
    
    protected TriggerListener(final TimingController timer, final Trigger.TriggerAction action) {
        this.timer = timer;
        this.action = action;
    }
    
    protected void pullTrigger() {
        if (this.action == Trigger.TriggerAction.START) {
            this.timer.start();
        }
        else {
            this.timer.stop();
        }
    }
}